Imports Microsoft.VisualBasic
Imports System.Data


''' <summary>
''' Klasa ChatRoomDB zapewnia dostp do pokojw rozmw i ich danych
''' </summary>
Public Class ChatRoom


#Region "Zmienne prywatne"

    Private _id As Integer
    Private _categoryid As Integer
    Private _name As String = String.Empty
    Private _description As String = String.Empty

#End Region

#Region "Konstruktor(y)"

    Public Sub New()

    End Sub

#End Region

#Region "Public Methods"

    ''' <summary>
    ''' Pobiera ChatRoom z bazy danych wywoujc metod Get() klasy ChatRoomDB.
    ''' </summary>
    Public Shared Function [Get](ByVal id As Integer) As ChatRoom

        Return ChatRoomDB.Get(id)

    End Function

    ''' <summary>
    ''' Zapisuje ChatRoom w bazie danych wywoujc metod Save() klasy ChatRoomDB. 
    ''' </summary>
    ''' <param name="mChatRoom">Egzemplarz klasy <see cref="ChatRoom" />, ktry ma by zapisany </param>
    Public Shared Function Save(ByVal mChatRoom As ChatRoom) As Integer
        Return ChatRoomDB.Save(mChatRoom)
    End Function

    ''' <summary>
    ''' Usuwa ChatRoom z bazy danych wywolujc metod Delete() klasy ChatRoomDB.
    ''' </summary>
    Public Shared Sub Delete(ByVal id As Integer)
        ChatRoomDB.Delete(id)
    End Sub

    ''' <summary>
    ''' Pobiera z bazy danych list pokojw rozmw w podanej kategorii.
    ''' </summary>
    ''' <returns></returns>
    Public Shared Function GetChatRoomList() As DataSet
        Return ChatRoomDB.GetChatRoomList()
    End Function

    ''' <summary>
    ''' Pobiera z bazy danych DateSet z wiadomociami z pokoju rozmw
    ''' </summary>
    Public Shared Function GetMessagesForChatRoom(ByVal id As Integer) As DataSet

        Return ChatRoomDB.GetMessagesForChatRoom(id)

    End Function

    ''' <summary>
    ''' Zapisuje wiadomo w odpowiednim pokoju rozmw w bazie danych
    ''' </summary>
    Public Shared Function SaveMessage(ByVal ChatRoomID As Integer, _
        ByVal Text As String, ByVal Email As String) As Boolean
        Return ChatRoomDB.SaveMessage(ChatRoomID, Text, Email)
    End Function




#End Region

#Region "Waciwoci publiczne"

    ''' <summary>
    ''' Pobiera lub ustawia identyfikator pokoju rozmw
    ''' </summary>
    Public Property ID() As String
        Get
            Return _id
        End Get
        Set(ByVal value As String)
            _id = value
        End Set
    End Property

    ''' <summary>
    ''' Pobiera lub ustawia nazw pokoju rozmw
    ''' </summary>
    Public Property Name() As String
        Get
            Return _name
        End Get
        Set(ByVal value As String)
            _name = value
        End Set
    End Property

    ''' <summary>
    ''' Pobiera lub ustawia opis pokoju rozmw
    ''' </summary>
    Public Property Description() As String
        Get
            Return _description
        End Get
        Set(ByVal value As String)
            _description = value
        End Set
    End Property

    ''' <summary>
    ''' Pobiera lub ustawia waciwo CategoryID pokoju rozmw. 
    ''' </summary>
    Public Property CategoryID() As Integer
        Get
            Return _categoryid
        End Get
        Set(ByVal value As Integer)
            _categoryid = value
        End Set
    End Property




#End Region

End Class
